/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
void InitPre()
{
   App.name="VI - Vertex Index Buffer";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);

   // to draw big number of shapes more efficiently please use VertexIndexBuffer (VI)

   Char *mode;

   if(Kb.b(KB_SPACE)) // when space on, draw in classic mode
   {
      REP(10000)D.line (GREEN, 0,0, Cos(i*PI2/10000),Sin(i*PI2/10000)); // draw 10000 lines      in classic mode
      REP(10000)D.rectL(ColorHue(i/10000.),Rect_C(0,0,i/20000.));       // draw 10000 rectangles in classic mode

      mode="Classic";
   }else // draw in buffered mode
   { 
      // draw lines
      {
                   VI.color(GREEN); // set green color
         REP(10000)VI.line (0,0, Cos(i*PI2/10000),Sin(i*PI2/10000)); // draw 10000 lines in buffered mode
                   VI.end  ();      // finish drawing
      }
      //draw rectangles
      {
         REP(10000)VI.rectL(ColorHue(i/10000.),Rect_C(0,0,i/20000.)); // draw 10000 lines in buffered mode
                   VI.end  (); // finish drawing
      }
      mode="Buffered";
   }

   D.text(0,0.9,S+mode+" drawing");
   D.text(0,0.8,S+"Fps: "+Tm.fps );
}
/******************************************************************************
NOTE:
Each type of drawing must be ended with it's own "end" method

   // forbidden
   {
      REP(10)VI.line(..);
      REP(10)VI.rect(..);
             VI.end ();
   }

   // good
   {
      REP(10)VI.line(..);
             VI.end ();

      REP(10)VI.rect(..)
             VI.end ();
   }

if one drawing method has color parameter and the other doesn't, it means they're different, and separate "end" is needed here as well

   // forbidden
   {
      REP(10)VI.line(RED, x0,y0,x1,y1);
      REP(10)VI.line(     x0,y0,x1,y1);
             VI.end ();
   }

   // good
   {
      REP(10)VI.line(RED, x0,y0,x1,y1);
             VI.end ();

             VI.color(RED);
      REP(10)VI.line (x0,y0,x1,y1);
             VI.end  ();
   }
/******************************************************************************/
